<?xml version="1.0" encoding="utf-8" ?> 

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>

	

	<xsl:include href='../../apt/core/controls.xslt'/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>



	<xsl:template match='combobox[@comboboxid = "ComboSearch"]'>

		<table class='form' cellspacing='0' cellpadding='0' border='0'>

			<colgroup>

				<col width='80px'/>

				<col width='200px'/>

				<col width='100px'/>

			</colgroup>

			<tr>

<!--				<td><input type="text" NAME="searchText"/></td> -->

				<td>Search what:</td>					

				<td>

					<span>

						<xsl:call-template name='comboBox'>

							<xsl:with-param name='id' select='"ComboSearch"'/>
							<xsl:with-param name='selected' select='"index=0"'/>
						</xsl:call-template>

					</span>

				</td>

				<td style="text-align:right;"><input type="button" id="searchSubmit" value="Search" style="width:80px;"/></td>

			</tr>

			<tr>

				<td colspan="2" nowrap="1"><input type="checkbox" id="matchCase" style="width:30px;">Match case</input></td>

				<td/>

			</tr>

			<tr>

				<td colspan="2" nowrap="1"><input type="checkbox" id="matchWholeWord" style="width:30px;">Match whole word</input></td>

				<td/>

			</tr>

			<tr>

				<td colspan="2" nowrap="1"><input type="checkbox" id="backwards" style="width:30px;">Go backwards</input></td>

				<td/>

			</tr>

		</table>

<!--		<script>

			function onSearch() {

				var option = 0;

				search_text = document.all['searchText'].value;

				if(document.all['WholeWordsOnlyMatch'].checked)

					option+=2;

				if(document.all['CaseMatch'].checked)

					option+=4;

				if(document.all['BackwardsMatch'].checked)

					option+=1;

				window.returnValue = new Array(search_text,option);

				window.close();

			}

		</script> -->

	</xsl:template>



	<xsl:template name='comboBoxOptions'>

		<xsl:param name='id'/>

		<xsl:param name='selected'/>		<!-- Selected option value -->

		<xsl:param name='comboBoxNode'/>	<!-- The <combobox> node in XML document if exists -->

		<xsl:param name='comboBoxDefine'/>

		<xsl:param name='comboBoxResource'/>



		<xsl:variable name='selectedName' select='substring-before($selected, "=")'/>

		<xsl:variable name='selectedValue' select='substring-after($selected, "=")'/>



		<xsl:if test='$comboBoxNode and $comboBoxNode/option'>

			<xsl:apply-templates select='$comboBoxNode/option'>

				<xsl:with-param name='selectedName' select='$selectedName'/>

				<xsl:with-param name='selectedValue' select='$selectedValue'/>

			</xsl:apply-templates>

		</xsl:if>



		<xsl:choose>

			<xsl:when test='$comboBoxDefine and $comboBoxDefine/option'>

				<xsl:apply-templates select='$comboBoxDefine/option'>

					<xsl:with-param name='selectedName' select='$selectedName'/>

					<xsl:with-param name='selectedValue' select='$selectedValue'/>

				</xsl:apply-templates>

			</xsl:when>

			<xsl:when test='$comboBoxResource and $comboBoxResource/option'>

				<xsl:apply-templates select='$comboBoxResource/option'>

					<xsl:with-param name='selectedName' select='$selectedName'/>

					<xsl:with-param name='selectedValue' select='$selectedValue'/>

				</xsl:apply-templates>

			</xsl:when>

		</xsl:choose>

	</xsl:template>



</xsl:stylesheet>

